Program Drzewo;
uses CRT;

{TYPY}
type

SWezelPtr = ^SWezel;

{ struktura przechowujaca wezel drzewa }
SWezel = record
    dana: integer;
    lewySyn : SWezelPtr;
    prawySyn : SWezelPtr;
end;

{ZMIENNE}
var
    korzen : SWezelPtr;

{PROCEDURY I FUNKCJE}

{ funkcja tworzaca zmienna typu SWezel }
function stworzNowyWezel(liczba : integer) : SWezelPtr;
var
    nowyWezel : SWezelPtr;
begin
    New(nowyWezel);
    nowyWezel^.lewySyn := nil;
    nowyWezel^.prawySyn := nil;
    nowyWezel^.dana := liczba;

    stworzNowyWezel := nowyWezel;
end;

{ procedura dodajaca nowy element do drzewa, korzystajaca z rekurencji }
procedure dodajWezel(wezelPoczatkowy : SWezelPtr; liczba: integer);
begin
    if korzen = nil then { gdy drzewo jest puste, korzen jest zmienna globalna przechowujaca korzen tworzonego drzewa }
    begin
        New(korzen);
        korzen := stworzNowyWezel(liczba) { tworzenie pierwszego wezla w drzewie }
    end
    else { jezeli drzewo niepuste }
        begin
            { jezeli nowa liczba mniejsza od wartosci w wezle dodaj do lewego podrzewa }
            if liczba < wezelPoczatkowy^.dana then
            begin
                { jezeli lewy syn nie jest pusty wywolaj rekurenyjnie dodawanie do lewego podrzewa }
                if wezelPoczatkowy^.lewySyn <> nil then
                    dodajWezel(wezelPoczatkowy^.lewySyn, liczba)
                { jezeli lewe podrzewo nie istnieje, to niech lewy syn wskazuje na nowo utworzony wezel z nowa wartoscia }
                else
                    wezelPoczatkowy^.lewySyn := stworzNowyWezel(liczba);
            end
            { jezeli nowa liczba rowna lub wieksza od wartosci w wezle dodaj do prawego podrzewa }
            else
            begin
                { jezeli prawy syn nie jest pusty wywolaj rekurenyjnie dodawanie do prawego podrzewa }
                if wezelPoczatkowy^.prawySyn <> nil then
                    dodajWezel(wezelPoczatkowy^.prawySyn, liczba)
                { jezeli prawe podrzewo nie istnieje, to niech prawy syn wskazuje na nowo utworzony wezel z nowa wartoscia }
                else
                    wezelPoczatkowy^.prawySyn := stworzNowyWezel(liczba);
            end;
        end;
end;

{ procedura rekurencyjnie przegladajaca drzewo }
procedure wypiszDrzewoNiemalejaco(wezelPoczatkowy: SWezelPtr);
begin
     { jezeli wezel nie jest pusty }
     if wezelPoczatkowy <> nil then
     begin
         { rekurencyjnie wypisz lewe poddrzewo }
         wypiszDrzewoNiemalejaco(wezelPoczatkowy^.lewySyn);
         { wypisz wartosc aktualnego wezla }
         Write(wezelPoczatkowy^.dana,', ');
         { rekurencyjnie wypisz prawe poddrzewo }
         wypiszDrzewoNiemalejaco(wezelPoczatkowy^.prawySyn);
     end;
end;

var
    i, liczba : integer;

begin

    WriteLn('Wygenerowane losowe liczby: ');

    { wygeneruj 10 losowych liczb }
    for i := 0 to 9 do
    begin
        liczba := random(100) + 1; { liczby z przedzialu <1, 100> }
        Write(liczba,', ');
        dodajWezel(korzen, liczba); { dodawaj wygenerowane liczby do drzewa }
    end;

    WriteLn();
    WriteLn('Posortowane elementy z drzewa: ');

    wypiszDrzewoNiemalejaco(korzen); { wypisz elemnety drzewa w osortowanej kolejnosci }


    WriteLn();
    WriteLn('Nacisnij klawisz ENTER by zakonczyc...');
    ReadKey;

end.

